IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[P_PDV_VD_IT_COMIS_RECALC_REGRESSAO_HISTORICO]')
          AND type IN(N'P', N'PC')
)
    BEGIN
        DROP PROCEDURE [P_PDV_VD_IT_COMIS_RECALC_REGRESSAO_HISTORICO]
    END;
GO

CREATE PROCEDURE [P_PDV_VD_IT_COMIS_RECALC_REGRESSAO_HISTORICO] (   @CD_EMP      INT = 1,
																   @CD_FILIAL   VARCHAR(MAX), 
																   @CD_FUN      VARCHAR(MAX)='',                           
																   @DT_INI      DATETIME = NULL,
																   @DT_FIM      DATETIME = NULL,
																   @CD_PROD     INT=0) 

--Processo de procedure criada especificadamente ao cliente cristina devido ambiente de memória reduzido ao para execução do processo : 04/03/2020 
--P_PDV_VD_IT_COMIS_RECALC_REGRESSAO 1,8,'3123','2022-08-01','2022-08-10'
AS
SET NOCOUNT ON  
--BEGIN TRY
BEGIN

DECLARE @CD_EMP_RS		INT
DECLARE @CD_FILIAL_RS	INT
DECLARE @CD_VD_RS		INT
DECLARE @CD_PROD_RS		INT
DECLARE @CD_VEND		INT
DECLARE @CD_VEND_RS		INT
DECLARE @CD_IT_RS INT
DECLARE @PERC_COMIS MONEY
DECLARE @DS_PERC_COMIS VARCHAR(100)
DECLARE @VLR_COMISSAO_FABRIC MONEY
DECLARE @DS_VLR_COMIS VARCHAR(100)
DECLARE @DS_PROD VARCHAR(200)
DECLARE @CD_VEND_PADRAO INT
DECLARE @FLAG_COMISSAO_OPERADOR INT
DECLARE @TIPO_PROC_COMISSAO INT

/*********************************************************************************************************/
print 'Inicio do processo = '+ convert (varchar ,getdate (),108)

	create table #tmp_filial(cd_emp int, cd_filial int, tp_regressao int)
	insert into #tmp_filial
	SELECT @CD_EMP, ID , 0 FROM UFD_PRM_IN_STRING(@CD_FILIAL)

/*********************************************************************************************************/
--Se nao tem regressao de comissao ... sai
if not exists (select top 1 * from EST_PROD_TBL_COMIS_REGRESSAO )
	return;
	 
	Create Table #TMP_VIEW_COMIS_POSSUI (CD_EMP INT,
											CD_FILIAL INT,
											CD_TBL_COMIS_REGRESSAO INT,
											CD_PROD	INT,
											OPERADOR	TINYINT,
											DT_EVENT1 DATETIME,
											DT_EVENT2 DATETIME,
											DT_EVENT3 DATETIME
											)


	--CATEGORIA	
	INSERT INTO #TMP_VIEW_COMIS_POSSUI
	SELECT DISTINCT      
		D.CD_EMP,           
		F.CD_FILIAL,          
		D.CD_TBL_COMIS_REGRESSAO,     
		A.CD_PROD, 
		0 AS OPERADOR,
		D.DT_EVENT AS DT_EVENT1,
		L.DT_EVENT AS DT_EVENT2,
		F.DT_EVENT AS DT_EVENT3
	 FROM 
		EST_PROD_TBL_COMIS_REGRESSAO_AUDIT_TRIGGER D  
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_ARV_MERC_CATEGORIA_AUDIT_TRIGGER L ON           
		D.CD_EMP = L.CD_EMP AND           
		D.CD_TBL_COMIS_REGRESSAO = L.CD_TBL_COMIS_REGRESSAO
		INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA A ON
		L.CD_EMP = A.CD_EMP AND
		L.CD_ARV_MERC_CATEG=A.CD_ARV_MERC_CATEG
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL_AUDIT_TRIGGER f ON
		d.CD_EMP					= f.CD_EMP AND
		d.CD_TBL_COMIS_REGRESSAO	= f.CD_TBL_COMIS_REGRESSAO
		inner join #tmp_filial LJ on
		F.CD_FILIAL	 = LJ.CD_FILIAL AND
		F.CD_EMP	 = LJ.CD_EMP 
	 where
		D.TP_REGRESSAO=0 --Categ
		AND D.STS_TBL=0

	--FABRICANTE	
	INSERT INTO #TMP_VIEW_COMIS_POSSUI
	SELECT distinct          
		D.CD_EMP,           
		F.CD_FILIAL,          
		D.CD_TBL_COMIS_REGRESSAO,     
		A.CD_PROD, 
		0 AS OPERADOR,
		D.DT_EVENT AS DT_EVENT1,
		L.DT_EVENT AS DT_EVENT2,
		F.DT_EVENT AS DT_EVENT3 
	 FROM 
		EST_PROD_TBL_COMIS_REGRESSAO_AUDIT_TRIGGER D  
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_PROD_FABRIC_AUDIT_TRIGGER L ON           
		D.CD_EMP				 = L.CD_EMP AND           
		D.CD_TBL_COMIS_REGRESSAO = L.CD_TBL_COMIS_REGRESSAO
		INNER JOIN  EST_PROD  A ON
		L.CD_EMP		= A.CD_EMP AND
		L.CD_FABRIC		= A.CD_FABRIC
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL_AUDIT_TRIGGER f ON
		d.CD_EMP					= f.CD_EMP AND
		d.CD_TBL_COMIS_REGRESSAO	= f.CD_TBL_COMIS_REGRESSAO
		inner join #tmp_filial LJ on
		F.CD_FILIAL	 = LJ.CD_FILIAL AND
		F.CD_EMP	 = LJ.CD_EMP 
	 where
		D.TP_REGRESSAO=1 --fabric
		AND D.STS_TBL=0

	--FAMILIA 
	INSERT INTO #TMP_VIEW_COMIS_POSSUI
	SELECT distinct          
		D.CD_EMP,           
		F.CD_FILIAL,          
		D.CD_TBL_COMIS_REGRESSAO,     
		A.CD_PROD, 
		0 AS OPERADOR ,
		D.DT_EVENT AS DT_EVENT1,
		L.DT_EVENT AS DT_EVENT2,
		F.DT_EVENT AS DT_EVENT3
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO_AUDIT_TRIGGER D 
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_ARV_MERC_FAMILIA_AUDIT_TRIGGER L ON           
		D.CD_EMP = L.CD_EMP AND           
		D.CD_TBL_COMIS_REGRESSAO = L.CD_TBL_COMIS_REGRESSAO
		INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA A ON
		L.CD_EMP = A.CD_EMP AND
		L.CD_ARV_MERC_FAMILIA=A.CD_ARV_MERC_FAMILIA
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL_AUDIT_TRIGGER f ON
		d.CD_EMP					= f.CD_EMP AND
		d.CD_TBL_COMIS_REGRESSAO	= f.CD_TBL_COMIS_REGRESSAO
		inner join #tmp_filial LJ on
		F.CD_FILIAL	 = LJ.CD_FILIAL AND
		F.CD_EMP	 = LJ.CD_EMP 
	where
		D.TP_REGRESSAO=2 --Family
		AND D.STS_TBL=0

	--LINHA
	INSERT INTO #TMP_VIEW_COMIS_POSSUI
	SELECT distinct          
		D.CD_EMP,           
		F.CD_FILIAL,          
		D.CD_TBL_COMIS_REGRESSAO,     
		A.CD_PROD, 
		0 AS OPERADOR ,
		D.DT_EVENT AS DT_EVENT1,
		L.DT_EVENT AS DT_EVENT2,
		F.DT_EVENT AS DT_EVENT3
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO_AUDIT_TRIGGER D  
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_ARV_MERC_LINHA_AUDIT_TRIGGER L ON           
		D.CD_EMP = L.CD_EMP AND           
		D.CD_TBL_COMIS_REGRESSAO = L.CD_TBL_COMIS_REGRESSAO
		INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA A ON
		L.CD_EMP = A.CD_EMP AND
		L.CD_ARV_MERC_LINHA=A.CD_ARV_MERC_LINHA 
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL_AUDIT_TRIGGER f ON
		d.CD_EMP					= f.CD_EMP AND
		d.CD_TBL_COMIS_REGRESSAO	= f.CD_TBL_COMIS_REGRESSAO
		inner join #tmp_filial LJ on
		F.CD_FILIAL	 = LJ.CD_FILIAL AND
		F.CD_EMP	 = LJ.CD_EMP 
	where
		D.TP_REGRESSAO=3 --Linha
		AND D.STS_TBL=0

	--Marca
	INSERT INTO #TMP_VIEW_COMIS_POSSUI
	SELECT distinct          
		D.CD_EMP,           
		F.CD_FILIAL,          
		D.CD_TBL_COMIS_REGRESSAO,     
		A.CD_PROD, 
		0 AS OPERADOR,
		D.DT_EVENT AS DT_EVENT1,
		L.DT_EVENT AS DT_EVENT2,
		F.DT_EVENT AS DT_EVENT3 
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO_AUDIT_TRIGGER D  
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_MC_AUDIT_TRIGGER l ON           
		D.CD_EMP = L.CD_EMP AND           
		D.CD_TBL_COMIS_REGRESSAO = L.CD_TBL_COMIS_REGRESSAO
		INNER JOIN  EST_PROD A ON
		L.CD_EMP = A.CD_EMP AND
		L.CD_MC  = A.CD_MC
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL_AUDIT_TRIGGER f ON
		d.CD_EMP					= f.CD_EMP AND
		d.CD_TBL_COMIS_REGRESSAO	= f.CD_TBL_COMIS_REGRESSAO
		inner join #tmp_filial LJ on
		F.CD_FILIAL	 = LJ.CD_FILIAL AND
		F.CD_EMP	 = LJ.CD_EMP 
	where
		D.TP_REGRESSAO=4 --Marca
		AND D.STS_TBL=0

	--PRODUTO 
	INSERT INTO #TMP_VIEW_COMIS_POSSUI
	SELECT distinct         
		D.CD_EMP,           
		F.CD_FILIAL,          
		D.CD_TBL_COMIS_REGRESSAO,     
		L.CD_PROD, 
		0 AS OPERADOR,
		D.DT_EVENT AS DT_EVENT1,
		L.DT_EVENT AS DT_EVENT2,
		F.DT_EVENT AS DT_EVENT3 
	FROM 
		EST_PROD_TBL_COMIS_REGRESSAO_AUDIT_TRIGGER D  
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_EST_PROD_AUDIT_TRIGGER L ON           
		D.CD_EMP = L.CD_EMP AND           
		D.CD_TBL_COMIS_REGRESSAO = L.CD_TBL_COMIS_REGRESSAO
		INNER JOIN EST_PROD_TBL_COMIS_REGRESSAO_PRC_FILIAL_AUDIT_TRIGGER f ON
		d.CD_EMP					= f.CD_EMP AND
		d.CD_TBL_COMIS_REGRESSAO	= f.CD_TBL_COMIS_REGRESSAO 
		inner join #tmp_filial LJ on
		F.CD_FILIAL	 = LJ.CD_FILIAL AND
		F.CD_EMP	 = LJ.CD_EMP  
	where
		D.TP_REGRESSAO=5 --Product
		AND D.STS_TBL=0

	UPDATE T
	SET
		OPERADOR=1
	from	
		#TMP_VIEW_COMIS_POSSUI T
		JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO C ON
		T.CD_EMP = C.CD_EMP AND
		T.CD_TBL_COMIS_REGRESSAO = C.CD_TBL_COMIS_REGRESSAO
		JOIN FP_CARGO F ON
		C.CD_CARGO= F.CD_CARGO AND
		C.CD_EMP= F.CD_EMP
	WHERE
		TP_CARGO=4 

CREATE INDEX IX_PESQUISA_01 ON [dbo].[#TMP_VIEW_COMIS_POSSUI] ([CD_EMP],[CD_FILIAL],[CD_PROD]);

/*********************************************************************************************************/

	SET @FLAG_COMISSAO_OPERADOR=0
	IF EXISTS(SELECT
				TOP 1 FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO.CD_CARGO
			FROM
				FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO 
				INNER JOIN FP_CARGO ON
				FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO.CD_EMP = FP_CARGO.CD_EMP AND
				FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO.CD_CARGO = FP_CARGO.CD_CARGO 
			WHERE
				TP_CARGO=4)
	begin
		SET @FLAG_COMISSAO_OPERADOR=1
	end
	 
	create table #tmp_vend(cd_fun int)
	 
	update t set tp_regressao=1
	from #tmp_filial t
		join (SELECT cd_emp, cd_filial 
				FROM PRC_FILIAL_CONFIG 
				WHERE CD_CHAVE='COMISSAO_TIPO_REGRESSIVO' AND VALOR ='1') r on 
		t.cd_emp	= r.cd_emp and
		t.cd_filial = r.cd_filial

	insert into #tmp_vend
	SELECT ID FROM UFD_PRM_IN_STRING(@CD_FUN) 

	CREATE TABLE #VendaComissao (CD_EMP INT,
								 CD_FILIAL INT,
								 CD_VD INT,
								 CD_IT INT,
								 CD_PROD INT,
								 CD_VEND INT,
								 QT_IT MONEY,
								 VLR_IT MONEY,
								 TX_DESC MONEY,
								 TX_DESC_CAD MONEY,
								 PERC_COMIS_VENDA MONEY,
								 VLR_COMISSAO_FABRIC_VENDA MONEY,
								 TIPO_PROC_COMISSAO INT,
								 TP_DESCONTO TINYINT,
								 PERC_DESC_VERBA MONEY,
								 DT_VD DATETIME)

	print 'Carregando vendas para calculo - linha 195 '+ convert (varchar ,getdate (),108)

	IF LTRIM(RTRIM(@CD_FUN))<>''
	begin
		INSERT INTO #VendaComissao
		SELECT  DISTINCT a.CD_EMP,
			a.CD_FILIAL,
			a.CD_VD,
			a.CD_IT,
			a.CD_PROD,
			a.CD_VEND,
			A.QT_IT,
			A.VLR_IT,
			A.TX_DESC,
			A.PERC_DESC_MIN,
			A.PERC_COMIS,
			A.VLR_COMISSAO_FABRIC,
			0 AS TIPO_COMISSAO,
			A.TIPO_DESCONTO,
			A.PERC_DESC_VERBA,
			a.dt_Vd
		FROM 
			PDV_VD_IT a 
			inner join #tmp_vend v on
			v.cd_fun= a.CD_VEND  
			inner join #tmp_filial L on
			A.CD_FILIAL= L.CD_FILIAL AND
			A.CD_EMP	 = L.CD_EMP   
			INNER JOIN FP_FUNC ON
			A.CD_EMP = FP_FUNC.CD_EMP AND
			A.CD_VEND = FP_FUNC.CD_FUN 
			INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
			FP_FUNC.CD_EMP = cc.CD_EMP AND
			FP_FUNC.CD_CARGO = cc.CD_CARGO
			INNER JOIN [#TMP_VIEW_COMIS_POSSUI] pc ON
			A.CD_EMP	= pc.CD_EMP AND 
			A.CD_FILIAL = pc.CD_FILIAL AND
			A.CD_PROD	= pc.CD_PROD
			AND (	COALESCE(pc.DT_EVENT1,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT2,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT3,'2023-04-06') <= a.dt_vd
			)
		WHERE
			a.CD_EMP = @CD_EMP
			AND A.DT_VD between @DT_INI AND @DT_FIM
			AND pc.OPERADOR =0
			AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
		 
		--Quando o vendedor mudou o cargo para que nao tem comissao ao longo do periodo 
		INSERT INTO #VendaComissao
		SELECT  DISTINCT a.CD_EMP,
			a.CD_FILIAL,
			a.CD_VD,
			a.CD_IT,
			a.CD_PROD,
			a.CD_VEND,
			A.QT_IT,
			A.VLR_IT,
			A.TX_DESC,
			A.PERC_DESC_MIN,
			A.PERC_COMIS,
			A.VLR_COMISSAO_FABRIC,
			0 AS TIPO_COMISSAO,
			A.TIPO_DESCONTO,
			A.PERC_DESC_VERBA,
			a.dt_Vd
		FROM 
			PDV_VD_IT a 
			inner join #tmp_vend v on
			v.cd_fun= a.CD_VEND  
			inner join #tmp_filial L on
			A.CD_FILIAL  = L.CD_FILIAL AND
			A.CD_EMP	 = L.CD_EMP   
			INNER JOIN FP_FUNC ON
			A.CD_EMP = FP_FUNC.CD_EMP AND
			A.CD_VEND = FP_FUNC.CD_FUN 
			LEFT OUTER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
			FP_FUNC.CD_EMP = cc.CD_EMP AND
			FP_FUNC.CD_CARGO = cc.CD_CARGO
		WHERE
			a.CD_EMP = @CD_EMP
			AND A.DT_VD between @DT_INI AND @DT_FIM
			AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
			AND cc.CD_CARGO IS NULL  
 
		IF @FLAG_COMISSAO_OPERADOR=1
		BEGIN
			INSERT INTO #VendaComissao
			SELECT  DISTINCT a.CD_EMP,
				a.CD_FILIAL,
				a.CD_VD,
				a.CD_IT,
				a.CD_PROD,
				FP_FUNC.CD_FUN ,
				A.QT_IT,
				A.VLR_IT,
				A.TX_DESC,
				A.PERC_DESC_MIN,
				PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.PERC_COMI,
				PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.VLR_COMISSAO_FABRIC,
				1 AS TIPO_COMISSAO,
				A.TIPO_DESCONTO,
				A.PERC_DESC_VERBA,
				a.dt_Vd
			FROM 
				PDV_VD_IT a INNER JOIN PDV_VD ON
				a.CD_EMP= PDV_VD.CD_EMP AND
				a.CD_FILIAL = PDV_VD.CD_FILIAL AND
				a.CD_VD = PDV_VD.CD_VD AND
				a.DT_VD = PDV_VD.DT_VD
				INNER JOIN #tmp_vend v ON
				v.cd_fun= a.CD_VEND  
				LEFT OUTER JOIN PDV_VD_IT_OPERADOR_CAIXA_COMISSAO ON
				a.CD_EMP= PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_EMP AND
				a.CD_FILIAL = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_FILIAL AND
				a.CD_VD = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_VD AND
				a.CD_IT = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_IT
				INNER JOIN #tmp_filial L ON
				A.CD_FILIAL= L.CD_FILIAL AND
				A.CD_EMP	 = L.CD_EMP   
				INNER JOIN FP_FUNC ON
				PDV_VD.CD_EMP = FP_FUNC.CD_EMP AND
				PDV_VD.CD_USU_OPE = FP_FUNC.CD_FUNC_USU 
				INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
				FP_FUNC.CD_EMP = cc.CD_EMP AND
				FP_FUNC.CD_CARGO = cc.CD_CARGO
				INNER JOIN [#TMP_VIEW_COMIS_POSSUI] pc ON
				A.CD_EMP	= pc.CD_EMP AND 
				A.CD_FILIAL	= pc.CD_FILIAL AND
				A.CD_PROD	= pc.CD_PROD 
				AND (	COALESCE(pc.DT_EVENT1,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT2,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT3,'2023-04-06') <= a.dt_vd
					)
			 
			WHERE
				a.CD_EMP = @CD_EMP
				AND A.DT_VD BETWEEN @DT_INI AND @DT_FIM 
				AND pc.OPERADOR =1
				AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
		END
	END
	 
	IF LTRIM(RTRIM(@CD_FUN))=''
	begin
		INSERT INTO #VendaComissao
		SELECT  DISTINCT a.CD_EMP,
			a.CD_FILIAL,
			a.CD_VD,
			a.CD_IT,
			a.CD_PROD,
			a.CD_VEND,
			A.QT_IT,
			A.VLR_IT,
			A.TX_DESC,
			A.PERC_DESC_MIN,
			A.PERC_COMIS,
			A.VLR_COMISSAO_FABRIC,
			0 AS TIPO_COMISSAO,
			A.TIPO_DESCONTO,
			A.PERC_DESC_VERBA,
			a.dt_Vd
		FROM 
			PDV_VD_IT a 
			inner join #tmp_filial L on
			A.CD_FILIAL= L.CD_FILIAL AND
			A.CD_EMP	 = L.CD_EMP   
			INNER JOIN FP_FUNC ON
			A.CD_EMP = FP_FUNC.CD_EMP AND
			A.CD_VEND = FP_FUNC.CD_FUN 
			INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS cc ON
			FP_FUNC.CD_EMP = cc.CD_EMP AND
			FP_FUNC.CD_CARGO = cc.CD_CARGO
			INNER JOIN [#TMP_VIEW_COMIS_POSSUI] pc ON
				A.CD_EMP	= pc.CD_EMP AND 
				A.CD_FILIAL	= pc.CD_FILIAL AND
				A.CD_PROD	= pc.CD_PROD 
				AND (	COALESCE(pc.DT_EVENT1,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT2,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT3,'2023-04-06') <= a.dt_vd
			)
		WHERE
			a.CD_EMP = @CD_EMP
			AND A.DT_VD between @DT_INI AND @DT_FIM
			and pc.OPERADOR=0
			AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
	--Quando o vendedor mudou o cargo para que nao tem comissao ao longo do periodo
		INSERT INTO #VendaComissao
		SELECT  DISTINCT a.CD_EMP,
			a.CD_FILIAL,
			a.CD_VD,
			a.CD_IT,
			a.CD_PROD,
			a.CD_VEND,
			A.QT_IT,
			A.VLR_IT,
			A.TX_DESC,
			A.PERC_DESC_MIN,
			A.PERC_COMIS,
			A.VLR_COMISSAO_FABRIC,
			0 AS TIPO_COMISSAO,
			A.TIPO_DESCONTO,
			A.PERC_DESC_VERBA,
			a.dt_Vd
		FROM 
			PDV_VD_IT a 
			inner join #tmp_filial L on
			A.CD_FILIAL= L.CD_FILIAL AND
			A.CD_EMP	 = L.CD_EMP   
			INNER JOIN FP_FUNC ON
			A.CD_EMP = FP_FUNC.CD_EMP AND
			A.CD_VEND = FP_FUNC.CD_FUN 
			LEFT OUTER JOIN FP_CARGO_EST_PROD_TBL_COMIS cc ON
			FP_FUNC.CD_EMP = cc.CD_EMP AND
			FP_FUNC.CD_CARGO = cc.CD_CARGO
		WHERE
			a.CD_EMP = @CD_EMP
			AND A.DT_VD between @DT_INI AND @DT_FIM
			AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
			AND cc.CD_CARGO IS NULL

	   
		IF @FLAG_COMISSAO_OPERADOR=1
		BEGIN 
			INSERT INTO #VendaComissao
			SELECT  DISTINCT a.CD_EMP,
				a.CD_FILIAL,
				a.CD_VD,
				a.CD_IT,
				a.CD_PROD,
				FP_FUNC.CD_FUN ,
				A.QT_IT,
				A.VLR_IT,
				A.TX_DESC,
				A.PERC_DESC_MIN,
				PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.PERC_COMI,
				PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.VLR_COMISSAO_FABRIC,
				1 AS TIPO_COMISSAO,
				A.TIPO_DESCONTO,
				A.PERC_DESC_VERBA,
				a.dt_Vd
			FROM 
				PDV_VD_IT a INNER JOIN PDV_VD ON
				a.CD_EMP= PDV_VD.CD_EMP AND
				a.CD_FILIAL = PDV_VD.CD_FILIAL AND
				a.CD_VD = PDV_VD.CD_VD AND
				a.DT_VD = PDV_VD.DT_VD
				LEFT OUTER JOIN PDV_VD_IT_OPERADOR_CAIXA_COMISSAO ON
				a.CD_EMP= PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_EMP AND
				a.CD_FILIAL = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_FILIAL AND
				a.CD_VD = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_VD AND
				a.CD_IT = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_IT
				INNER JOIN #tmp_filial L ON
				A.CD_FILIAL= L.CD_FILIAL AND
				A.CD_EMP	 = L.CD_EMP   
				INNER JOIN FP_FUNC ON
				PDV_VD.CD_EMP = FP_FUNC.CD_EMP AND
				PDV_VD.CD_USU_OPE = FP_FUNC.CD_FUNC_USU 
				INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
				FP_FUNC.CD_EMP = cc.CD_EMP AND
				FP_FUNC.CD_CARGO = cc.CD_CARGO
				INNER JOIN [#TMP_VIEW_COMIS_POSSUI] pc ON
				A.CD_EMP	= pc.CD_EMP AND 
				A.CD_FILIAL	= pc.CD_FILIAL AND
				A.CD_PROD	= pc.CD_PROD 
				AND (	COALESCE(pc.DT_EVENT1,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT2,'2023-04-06') <= a.dt_vd
					and COALESCE(pc.DT_EVENT3,'2023-04-06') <= a.dt_vd
			)
			WHERE
				a.CD_EMP = @CD_EMP
				AND A.DT_VD BETWEEN @DT_INI AND @DT_FIM
				AND pc.OPERADOR=1
				AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END 
		END
	END
------------------------------------------------------------------------------------------------------------------------
-- Tipo desconto PBM
	UPDATE 	C 
	SET
		TX_DESC_CAD =CONVERT(MONEY,((((C.QT_IT*C.VLR_IT)-P.VLR_PROD_CLI)/C.VLR_IT)*100.00)+C.TX_DESC_CAD) 
	from 
		#VendaComissao c
		join pdv_vd_it_vd_pbm p on 
		C.CD_EMP	= P.CD_EMP AND
		C.CD_FILIAL = P.CD_FILIAL AND
		C.CD_VD		= P.CD_VD AND
		C.CD_IT		= P.CD_IT
	where
		c.TP_DESCONTO=5
		AND C.TX_DESC >0
------------------------------------------------------------------------------------------------------------------------
-- Tramento de valores null
 	UPDATE #VendaComissao
	SET 
		TX_DESC = ISNULL(TX_DESC, 0), 
		TX_DESC_CAD = ISNULL(TX_DESC_CAD, 0), 
		PERC_COMIS_VENDA = ISNULL(PERC_COMIS_VENDA, 0), 
		VLR_COMISSAO_FABRIC_VENDA = ISNULL(VLR_COMISSAO_FABRIC_VENDA, 0);

------------------------------------------------------------------------------------------------------------------------
-- Nao considera verba regressao como desconto empresa:  0 - CONSIDERA , 1 - DESCONSIDERA
 
	UPDATE V 
	SET 
		TX_DESC_CAD = (CASE WHEN ISNULL(TX_DESC_CAD - PERC_DESC_VERBA, 0) < 0 THEN 0
						ELSE  ISNULL(TX_DESC_CAD - PERC_DESC_VERBA, 0) END)
	FROM
		#VendaComissao v
		inner join (  SELECT CD_EMP, CD_FILIAL
						 FROM PRC_FILIAL_CONFIG 
						 WHERE 
							CD_EMP=1
							AND CD_CHAVE = 'FLAG_DESCONSIDERA_DESCONTO_VERBA_PARA_REGREDIR_COMISSAO' ) L on
									v.CD_FILIAL= L.CD_FILIAL AND
									v.CD_EMP	 = L.CD_EMP 

------------------------------------------------------------------------------------------------------------------------
--COMISSAO_TIPO_REGRESSIVO

	UPDATE v
	SET 
		TX_DESC = ISNULL(TX_DESC, 0), 
		TX_DESC_CAD =CASE WHEN tp_regressao=1 THEN 0 ELSE ISNULL(TX_DESC_CAD, 0) END, 
		PERC_COMIS_VENDA = ISNULL(PERC_COMIS_VENDA, 0), 
		VLR_COMISSAO_FABRIC_VENDA = ISNULL(VLR_COMISSAO_FABRIC_VENDA, 0)
	from 
		#VendaComissao v
		inner join #tmp_filial L on
			v.CD_FILIAL= L.CD_FILIAL AND
			v.CD_EMP	 = L.CD_EMP
		  
	DELETE FROM v
		FROM #VendaComissao v 
		 inner join #tmp_filial L on
			  v.CD_FILIAL= L.CD_FILIAL AND
			  v.CD_EMP	 = L.CD_EMP
	WHERE TX_DESC=0
		and l.tp_regressao=1;

	DELETE FROM v
		FROM #VendaComissao v 
		 inner join #tmp_filial L on
			  v.CD_FILIAL= L.CD_FILIAL AND
			  v.CD_EMP	 = L.CD_EMP
	WHERE TX_DESC=0
		and l.tp_regressao=1;

------------------------------------------------------------------------------------------------------------------------
--Remove os tipos de desconto nao vinculados a regressao
	DELETE FROM V
	FROM #VendaComissao v 
		cross apply (SELECT *
						FROM (
								SELECT ROW_NUMBER() OVER(PARTITION BY TP_DESCONTO ORDER BY COALESCE(DT_EVENT,'2000-01-01') DESC) AS RN, *
								FROM EST_GRP_COMIS_DESC_REGRESSAO_audit_trigger AUD
								WHERE COALESCE(DT_EVENT,'2000-01-01') <= v.dt_vd
								and v.TP_DESCONTO = AUD.TP_DESCONTO
							 ) Q
						WHERE Q.RN = 1
					) c
		where c.VINCULADO=0
		

------------------------------------------------------------------------------------------------------------------------
--Debug
--  SELECT * FROM #VendaComissao  
------------------------------------------------------------------------------------------------------------------------ 

	print 'Inicio do calculo de comissao - linha 500 '+ convert (varchar ,getdate (),108)

	DECLARE ComissaoItensRegressao 
	CURSOR FAST_FORWARD READ_ONLY FOR
	SELECT  DISTINCT a.CD_EMP,
		a.CD_FILIAL,
		a.CD_VD,
		a.CD_IT,
		a.CD_PROD,
		a.CD_VEND,
		ISNULL(F.PERC_COMIS,0),
		ISNULL(F.DS_COMIS_PERC,'NAO DEFINIDO'),
		ISNULL(F.VLR_COMIS,0),
		ISNULL(F.DS_COMIS_VLR,'NAO DEFINIDO'),
		EST_PROD.DS_PROD,
		TIPO_PROC_COMISSAO
	FROM 
		#VendaComissao a 
		INNER JOIN EST_PROD ON
		a.CD_EMP = EST_PROD.CD_EMP AND
		a.CD_PROD = EST_PROD.CD_PROD 
		OUTER APPLY UFD_EST_PROD_COMIS_REGRESSAO_HISTORICO(A.CD_EMP, a.CD_FILIAL, a.CD_PROD, a.CD_VEND,A.TX_DESC,A.TX_DESC_CAD, A.DT_VD) F 
	WHERE
		(A.PERC_COMIS_VENDA <> ISNULL(F.PERC_COMIS,0)
			OR A.VLR_COMISSAO_FABRIC_VENDA <> ISNULL(F.VLR_COMIS,0))
   
  --Abrindo cursor
  OPEN ComissaoItensRegressao  
  FETCH NEXT FROM ComissaoItensRegressao INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
								@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
								@PERC_COMIS,@DS_PERC_COMIS,
								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD,@TIPO_PROC_COMISSAO


  --Iniciando laço
  WHILE @@FETCH_STATUS = 0
   BEGIN   
		IF @TIPO_PROC_COMISSAO=0
		begin
			print 'Filial ' + convert(varchar(100), @CD_FILIAL_RS) +  ' Vendedor.: ' + convert(varchar(100), @CD_VEND_RS) + ' produto.: ' + convert(varchar(100), @CD_PROD_RS) + ' ' + @DS_PROD + ' tipo comissao.:  ' + @DS_PERC_COMIS + ' descri. comissao.:  ' + @DS_VLR_COMIS + ' perc.comissao.: ' + convert(varchar(10),@PERC_COMIS) + ' - ' +  convert(varchar(10),Getdate(),112 ) + ' ' +  convert(varchar(10),Getdate(),108) 
			UPDATE I
				SET 
					I.PERC_COMIS =  @PERC_COMIS,
					I.PERC_COMI = @PERC_COMIS,
					I.DS_PERC_COMIS = @DS_PERC_COMIS,
					I.VLR_COMISSAO_FABRIC =@VLR_COMISSAO_FABRIC ,
					I.DS_VLR_COMIS = @DS_VLR_COMIS
				FROM  PDV_VD_IT I
				WHERE I.CD_EMP = @CD_EMP_RS
						AND I.CD_FILIAL = @CD_FILIAL_RS        
						AND I.CD_VD = @CD_VD_RS
						AND I.CD_VEND = @CD_VEND_RS
						AND I.CD_IT = @CD_IT_RS
						AND I.CD_PROD = @CD_PROD_RS
		END
		ELSE
		BEGIN
			print 'Filial ' + convert(varchar(100), @CD_FILIAL_RS) +  ' operador caixa.: ' + convert(varchar(100), @CD_VEND_RS) + ' produto.: ' + convert(varchar(100), @CD_PROD_RS) + ' ' + @DS_PROD + ' tipo comissao.:  ' + @DS_PERC_COMIS + ' descri. comissao.:  ' + @DS_VLR_COMIS + ' perc.comissao.: ' + convert(varchar(10),@PERC_COMIS)+ ' - ' +  convert(varchar(10),Getdate(),112 ) + ' ' +  convert(varchar(10),Getdate(),108) 

			DELETE 
				I
			FROM 
				PDV_VD_IT_OPERADOR_CAIXA_COMISSAO I
			WHERE 
				I.CD_EMP = @CD_EMP_RS
				AND I.CD_FILIAL = @CD_FILIAL_RS        
				AND I.CD_VD = @CD_VD_RS
				AND I.CD_IT = @CD_IT_RS

			INSERT INTO PDV_VD_IT_OPERADOR_CAIXA_COMISSAO (CD_EMP,
															CD_FILIAL,
															CD_VD,
															CD_IT,
															PERC_COMI,
															DS_PERC_COMIS,
															DS_VLR_COMIS,
															VLR_COMISSAO_FABRIC,
															CD_USU)
			SELECT
				@CD_EMP_RS,
				@CD_FILIAL_RS,        
				@CD_VD_RS,
				@CD_IT_RS,
				@PERC_COMIS,
				@DS_PERC_COMIS,
				@DS_VLR_COMIS,
				@VLR_COMISSAO_FABRIC,
				1
		END
		--Próxima linha do cursor
		FETCH NEXT FROM ComissaoItensRegressao INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
							@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
							@PERC_COMIS,@DS_PERC_COMIS,
							@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD,@TIPO_PROC_COMISSAO
  
   END

  CLOSE ComissaoItensRegressao
  DEALLOCATE ComissaoItensRegressao 

  print 'Inicio do calculo de comissao DEVOLUCAO - linha 500 '+ convert (varchar ,getdate (),108)

--Nome do cursor para devolução
	DECLARE ComissaoItensRegressaoDev 
	CURSOR FAST_FORWARD READ_ONLY FOR
	SELECT
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP,
		PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL,
		PDV_VD_DEV_EST_PROD_IMP.CD_VD,
		PDV_VD_DEV_EST_PROD_IMP.CD_IT,
		PDV_VD_DEV_EST_PROD_IMP.CD_PROD,
		PDV_VD_DEV_EST_PROD_IMP.CD_VEND,
		ISNULL(PDV_VD_IT.PERC_COMIS,0),
		ISNULL(PDV_VD_IT.DS_PERC_COMIS,'NAO DEFINIDO'),
		ISNULL(PDV_VD_IT.VLR_COMISSAO_FABRIC,0),
		ISNULL(PDV_VD_IT.DS_VLR_COMIS,'NAO DEFINIDO'),
		EST_PROD.DS_PROD
	FROM
		PDV_VD_DEV_EST_PROD_IMP 
		INNER JOIN PDV_VD_IT ON
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP=PDV_VD_IT.CD_EMP AND
		PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
		PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD_IT.CD_VD AND
		PDV_VD_DEV_EST_PROD_IMP.CD_PROD = PDV_VD_IT.CD_PROD AND
		PDV_VD_DEV_EST_PROD_IMP.CD_IT = PDV_VD_IT.CD_IT
		inner join #tmp_filial L on
		PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL= L.CD_FILIAL AND
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP	 = L.CD_EMP   
		INNER JOIN EST_PROD ON
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD.CD_EMP AND
		PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD.CD_PROD 
	WHERE
		PDV_VD_DEV_EST_PROD_IMP.CD_EMP=@CD_EMP
		AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO between @DT_INI AND @DT_FIM
		AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD = CASE WHEN @CD_PROD=0 THEN PDV_VD_DEV_EST_PROD_IMP.CD_PROD ELSE @CD_PROD END
		AND (PDV_VD_DEV_EST_PROD_IMP.PERC_COMIS <> PDV_VD_IT.PERC_COMIS 
		OR PDV_VD_DEV_EST_PROD_IMP.VLR_COMISSAO_FABRIC <> PDV_VD_IT.VLR_COMISSAO_FABRIC )	
  
  --Abrindo cursor
	OPEN ComissaoItensRegressaoDev
	FETCH NEXT FROM ComissaoItensRegressaoDev INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
												@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
												@PERC_COMIS,@DS_PERC_COMIS,
												@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD

  --Iniciando laço
  WHILE @@FETCH_STATUS = 0
   BEGIN   
	print 'Filial ' + convert(varchar(100), @CD_FILIAL_RS) +  ' Devolucao Vendedor.: ' + convert(varchar(100), @CD_VEND_RS) + ' produto.: ' + convert(varchar(100), @CD_PROD_RS) + ' ' + @DS_PROD +  ' tipo comissao.:  ' + @DS_PERC_COMIS + ' descri. comissao.: ' + @DS_VLR_COMIS + ' perc.comissao.: ' + convert(varchar(10),@PERC_COMIS)+ ' - ' +  convert(varchar(10),Getdate(),112 ) + ' ' +  convert(varchar(10),Getdate(),108) 
		 UPDATE I
		    SET 
				I.PERC_COMIS = @PERC_COMIS,
				I.DS_PERC_COMIS = @DS_PERC_COMIS,
				I.VLR_COMISSAO_FABRIC = @VLR_COMISSAO_FABRIC,
				I.DS_VLR_COMIS = @DS_VLR_COMIS	
		    FROM PDV_VD_DEV_EST_PROD_IMP i			
		    WHERE I.CD_EMP = @CD_EMP_RS
				 AND I.CD_FILIAL = @CD_FILIAL_RS        
				 AND I.CD_VD = @CD_VD_RS
				 AND I.CD_VEND = @CD_VEND_RS
				 AND I.CD_IT = @CD_IT_RS				
				 AND (ISNULL(I.PERC_COMIS,0) <> @PERC_COMIS OR
					  ISNULL(I.VLR_COMISSAO_FABRIC,0) <> @VLR_COMISSAO_FABRIC)
      --Próxima linha do cursor
	FETCH NEXT FROM ComissaoItensRegressaoDev INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
								@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
								@PERC_COMIS,@DS_PERC_COMIS,
								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD
    
   END

	CLOSE ComissaoItensRegressaoDev
	DEALLOCATE ComissaoItensRegressaoDev 
	 
	IF  OBJECT_ID('TEMPDB.DBO.#tmp_vend') IS NOT NULL
	BEGIN
			DROP TABLE #tmp_vend
	END	
	IF  OBJECT_ID('TEMPDB.DBO.#tmp_filial') IS NOT NULL
	BEGIN
			DROP TABLE #tmp_filial
	END

	IF  OBJECT_ID('TEMPDB.DBO.#VendaComissao') IS NOT NULL
	BEGIN
			DROP TABLE #VendaComissao
	END
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_VIEW_COMIS_POSSUI') IS NOT NULL
	BEGIN
			DROP TABLE #TMP_VIEW_COMIS_POSSUI
	END	
END
/*
END TRY
BEGIN CATCH
 INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
  SELECT
   ERROR_NUMBER() AS numero,
   ERROR_SEVERITY() AS severidade,
   ERROR_STATE() AS estado,
   ERROR_PROCEDURE() AS rotina,
   ERROR_LINE() AS linha,
   ERROR_MESSAGE() AS mensagem,
   GETDATE() AS dtErro; 
END CATCH
*/

